require 'rspec'
require 'watir-scroll'

require_relative '../../module/DriverUtility'
require_relative '../rspec_helper'
require_relative '../../pages/varUtility/landing'
require_relative '../../helper/modal'
require_relative '../../common/accessVarUtility'
require_relative '../../common/common'
require_relative '../../pages/varUtility/manage_settings'
require_relative '../../module/DateUtility'
require_relative '../../helper/table'
require_relative '../../pages/varUtility/error_validation'
require_relative '../../pages/varUtility/manage_settings/request_settings'
require_relative '../../pages/varUtility/manage_settings/direct_scheduling'
require_relative '../../pages/varUtility/manage_settings/custom_messages'
require_relative '../../module/database/MongoUtility'
require_relative '../../pages/vaToolSet/home'
require_relative '../../pages/landing_page'

require_relative '../rspec_helper'
require 'vaToolSet/vaToolSet_pageObject'

describe '[Story VARUT-1642: Utility - Authorized Landing Page - Location Level]
          [Story VARUT-1643: Direct Scheduling Configuration Page - Update to reflect Facility Location Level configuration]
          [Story VARUT-1644: Request Configuration Page - Update to reflect Facility Location Level configuration]
          [Story VARUT-1784: Custom Messages:  Update labeling to "Custom Text"]' do

  include DriverUtility
  include DateUtility
  include MongoUtility

  before(:all) do
    initializeConfigurations(BASE_URL)
    @login = Login.new(@driver)
    @table = Table.new(@driver)
    @home = Home.new(@driver)
    @manage_setting = Manage_Settings.new(@driver)
    @direct_scheduling = Direct_Scheduling.new(@driver)
    @request_setting = Request_Settings.new(@driver)
    @custom_messages = Custom_Messages.new(@driver)
    @landing = Landing.new(@driver)
    @landing_page = LandingPage.new(@driver)

    @vts_po  = VaToolSet_PageObject.new(@driver)

    @vts_po.loginLogout.login(UserAccess7)
    #Access VAR Utility
    @home.varUtilOpen_element.wait_until_present(TIME_OUT_LIMIT)
    @home.varUtilOpen

  end

  after(:all) do
    @driver.close
  end

  context '[Story VARUT-1642|AC#VARUT-1742|TC#VARUT-1743 - Authorized Landing Page - Location Level]' do
    it 'should choose facility and select View Settings' do
      #Choose Facility and Select View Settings button
      @landing_page.facility_location_element.wait_until_present(TIME_OUT_LIMIT)
      @landing_page.facility_location_element.select_value('BOSTON HCS VAMC')
      @landing_page.view_settings_element.wait_until_present(TIME_OUT_LIMIT)
      @landing_page.view_settings
    end

    it 'should have following under Manage/View Settings panel
        Button- Change Location
        Three options-
        Direct Scheduling
        Requests
        Custom Messages' do
      @landing_page.change_location_element.wait_until_present(TIME_OUT_LIMIT)
      expect(@landing_page.change_location_element.text).to eq("Change Location")
      expect(@landing_page.options_list_element[0].text).to eq("Direct Scheduling")
      expect(@landing_page.options_list_element[1].text).to eq("Requests")
      expect(@landing_page.options_list_element[2].text).to eq("Custom Text")
    end

    it 'should have the following under Detail panel
        Welcome
        Welcome <User first name> <User last name>
        <date Month dd, YYYY>
        Text: You are viewing settings for:
        <Facility Location Name>
        Note that any changes to this locations settings affect all clinics associated with this location.' do
      @landing_page.detail_panel_text_element.wait_until_present(TIME_OUT_LIMIT)
      expect(@landing_page.detail_panel_text_element.text).to eq("Welcome\nWelcome SEVEN PROVIDER\n#{@landing_page.getLocalDate}\nYou are viewing settings for:\nBOSTON HCS VAMC\nNote that any changes to this location's settings affect all clinics associated with this location.")
    end

  end

  context '[Story VARUT-1643|AC#VARUT-1746|TC#VARUT-1747 - Direct Scheduling Configuration Page - Update to reflect Facility Location Level configuration]' do
    it 'should show the following text changes when Direct Scheduling option is selected:
        Direct Scheduling
        <location name (bold)> Direct Scheduling Settings
        For the care types listed below, provide the direct scheduling settings supported by this location.
        Table title: Clinic Profile Based Types of Care' do
      @manage_setting.clickOption('Direct Scheduling')
      @landing.primary_header_element.wait_until_present(TIME_OUT_LIMIT)
      expect(@landing.primary_header).to eq("Direct Scheduling")
      expect(@direct_scheduling.direct_scheduling_settings_heading_element.text).to eq("BOSTON HCS VAMC Direct Scheduling Settings")
      expect(@direct_scheduling.instructional_text_element.text).to eq("For the care types listed below, provide the direct scheduling settings supported by this location.")
      expect(@direct_scheduling.type_of_care_table_title_element.text).to eq("Clinic Profile Based Types of Care")
    end

  end

  context '[Story VARUT-1644|AC#VARUT-1748|TC#VARUT-1749 - Request Configuration Page - Update to reflect Facility Location Level configuration]' do
    it'should show the following text changes when Requests option is selected
        <location name (bold)> Request Settings
        For the care types in the groupings listed below, provide the request settings supported by this location.
        Table title: Clinic Profile Based Types of Care' do
      @manage_setting.clickOption('Requests')
      @landing.primary_header_element.wait_until_present(TIME_OUT_LIMIT)
      expect(@landing.primary_header).to eq("Requests")
      expect(@request_setting.request_settings_heading_element.text).to eq("BOSTON HCS VAMC Request Settings")
      expect(@request_setting.instructional_text_element.text).to eq("For the care types in the groupings listed below, provide the request settings supported by this location.")
      expect(@request_setting.type_of_care_table_title_element.text).to eq("Clinic Profile Based Types of Care")
    end

  end

  context '[Story VARUT-1646|AC#VARUT-1750|TC#VARUT-1751 - Custom Messages - Facility Location Level]
           [Story VARUT-1784| AC#VARUT-1804|TC#VARUT-1805 : Custom Messages:  Update labeling to "Custom Text"]' do
    it'should show the following text changes when Custom Text option is selected
        <location name (bold)> Request Settings
        For the care types in the groupings listed below, provide the request settings supported by this location.
        Table title: Clinic Profile Based Types of Care' do
      @manage_setting.clickOption('Custom Text')
      @landing.primary_header_element.wait_until_present(TIME_OUT_LIMIT)
      expect(@custom_messages.custom_messages_heading_element.text).to eq("BOSTON HCS VAMC Custom Text")
      expect(@custom_messages.instructional_text_element.text).to eq("Customize the text below to provide information that is specific to this location and its clinics.")
    end

  end


end

